#version 130
#extension GL_EXT_gpu_shader4 : enable
//mountain-v2Mod02.fsh  by  jorge2017a1
//https://www.shadertoy.com/view/wlXBWB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1-


#define MAX_STEPS 100
#define MAX_DIST 100.
#define SURF_DIST .001
//#define PI 3.14159

///------------------------------------
struct TObj
{
    float idcolor;
    float id_obj;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 rf;
   
};


TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;



#define PI 3.14159265358979323846264
#define PI2 6.28318530717
#define TriplePI (3.0 * PI)
#define DoublePI (2.0 * PI)
#define HalfPI (PI / 2.0)




vec3 hsv(vec3 c)
{
    vec4 k=vec4(1.,2./3.,1./3.,3.);
    vec3 p=abs(fract(c.xxx+k.xyz)*6.-k.www);
    return c.z*mix(k.xxx,clamp(p-k.xxx,0.,1.),c.y);
}



///Gracias por la Ayuda de SHane...16-jun-2020
// Creditos a Shane por su funcion tex3D
// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: http://http.developer.nvidia.com/GPUGems3/gpugems3_ch01.html
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    
    // Ryan Geiss effectively multiplies the first line by 7. It took me a while to realize that 
    // it's largely redundant, due to the division process that follows. I'd never noticed on 
    // account of the fact that I'm not in the habit of questioning stuff written by Ryan Geiss. 
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    //n /= length(n); 
    
    // Texure samples. One for each plane.
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    
    // Multiply each texture plane by its normal dominance factor.... or however you wish
    // to describe it. For instance, if the normal faces up or down, the "ty" texture sample,
    // represnting the XZ plane, will be used, which makes sense.
    
    // Textures are stored in sRGB (I think), so you have to convert them to linear space 
    // (squaring is a rough approximation) prior to working with them... or something like that. 
    // Once the final color value is gamma corrected, you should see correct looking colors.
    return mat3(tx*tx, ty*ty, tz*tz)*n; // Equivalent to: tx*tx*n.x + ty*ty*n.y + tz*tz*n.z;

}




float random() 
{
	return fract(sin(dot(mObj.uv, vec2(12.9898, 78.233)) ) * 43758.5453);
}



vec3 checkerBoard(float u, float v, float interval)
{
    float uu = floor(u/interval*2.0);
    float vv = floor(v/interval*2.0);
    float p =mod(uu+vv,2.0);
    return vec3(0.1+0.9*p);
}



//----------------------------------------------------


vec3 getColor(int i)
{
    
    float m;
if (i==-2 ) { return mObj.color; }       
if (i==0 ) { return vec3(0,0,0)/255.0; }
if (i==1 ) { return vec3(255.,255.,255.)/255.0; }
if (i==2 ) { return vec3(255,0,0)/255.0; }
if (i==3 ) { return vec3(0,255,0)/255.0; }
if (i==4 ) { return vec3(0,0,255)/255.0; }
if (i==5 ) { return vec3(255,255,0)/255.0; }
if (i==6 ) { return vec3(0,255,255)/255.0; }
if (i==7 ) { return vec3(255,0,255)/255.0; }
if (i==8 ) { return vec3(192,192,192)/255.0; }
if (i==9 ) { return vec3(128,128,128)/255.0; }
if (i==10 ) { return vec3(128,0,0)/255.0; }
if (i==11 ) { return vec3(128,128,0)/255.0; }
if (i==12 ) { return vec3(0,128,0)/255.0; }
if (i==13 ) { return vec3(128,0,128)/255.0; }
if (i==14 ) { return vec3(0,128,128)/255.0; }
if (i==15 ) { return vec3(0,0,128)/255.0; }
    
if (i==16 ) { return vec3(255, 204, 188)/255.0; }
if (i==17 ) { return vec3(0.8, 0.8, 0.8); }
if (i==18 ) { return vec3(0.5, 0.5, 0.8); }

    if(i== 19 )
    {  return vec3(1, 0.5, 0);    } 
    if(i== 20 )
    { return vec3(1.0, 1.0, 1.0); } 
    if(i== 21 )
    {  return vec3(247./255., 168./255.,  184./255.);  } 
    if(i== 22 )
    { return vec3(0, 1, 1);} 
    if(i== 23 )
    { return vec3(85./255., 205./255., 252./255.); } 
    
    
}

///--------------------------------------------



vec3 light_pos1   ;
vec3 light_color1 ;
vec3 light_pos2   ;
vec3 light_color2 ;


///-----------------------------------------
///---------------------------------------
float intersectSDF(float distA, float distB) {
    return max(distA, distB);
}

float unionSDF(float distA, float distB) 
{
    return min(distA, distB);
}

float differenceSDF(float distA, float distB) 
{
    return max(distA, -distB);
}


vec2 opU(vec2 d1, vec2 d2 ) {
  vec2 resp;
    if (d1.x < d2.x){ 
        resp = d1;
    }
    else
    {
        resp = d2;
    }
     
   return resp; 
}
///------------------------------------


vec3 LightShading(vec3 Normal,vec3 toLight,vec3 toEye,vec3 color)
{
    vec3 toReflectedLight=reflect(-toLight, Normal);
    vec3 diffuse = max(0.,dot(Normal,-toLight))*color;
    //vec3 specular = pow(max(0.,dot(Normal,normalize(-toLight-V))),100.)*vec3(1.,1.,1.); 
    float specularf=max(dot(toReflectedLight, toEye),0.0);
    specularf=pow(specularf, 100.0);
    vec3 specular =specularf*vec3(1.0);
    
    return diffuse + specular;
}



///-----------------------------------
vec2 rotate(vec2 v, float a) {
   return vec2(cos(a)*v.x + sin(a)*v.y, -sin(a)*v.x + cos(a)*v.y);
}
//----------------------------------------------------

mat2 rotate(float a) 
{
	float c = cos(a);
	float s = sin(a);
	return mat2(c, s, -s, c);
}

//----------------------------------------------------

float pathterrainv4( vec3 p)
{
    // Common height function for path and terrain
    return 
        0.5*sin(p.x*.25 )*2.+cos(p.z*0.023 )*0.3+p.y*0.25
        +cos(p.x*0.3+p.z )*0.35+sin(p.x*0.15-p.z*0.52 )*0.8+ 2.0*sin(p.x*0.33+sin(p.z*0.25));
}  



///------------------------
float GetDist(vec3 p  ) 
{	

    float d, dif1, dif2;
    vec2 res;
    vec3 pp,p1, p2,p3; 
    res = vec2(9999, 0);
   
        
    
	vec3 q=p;
    
    
    float cx=47.0;
    float cy=11.0;
    float cz=2.00;
    
    
   
    
    
    float sdpt1= pathterrainv4(p);
    res =opU(res, vec2(sdpt1,100.0)); 
    
    
    
    res =opU(res, vec2(1.0,0.0)); 
    
    
    d = res.x;
    mObj.dist = res.x;
    mObj.idcolor = res.y;
    
    return d;
}



//---------actualizacion por Shane---28-may-2020    ...gracias
float RayMarch(vec3 ro, vec3 rd) 
{
	
    // The extra distance might force a near-plane hit, so
    // it's set back to zero.
    float dO = 0.; 
    //Determines size of shadow
    for(int i=0; i<MAX_STEPS; i++) 
    {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
        dO += dS;
        
    }
    
    return dO;
}




//---------------------------------------------------

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    //Texture of white and black in image
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}





float GetLightPar(vec3 p, vec3 plig) {
    vec3 lightPos = plig;
    //Determine movement of light ex. shadow and light direction and diffusion
   
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*SURF_DIST*2., l );
    if(d<length(lightPos-p)) dif *= .1;
    
    return dif;
}


float saturate(float f)
{
	return clamp(f,0.0,1.0);
}


//----------------------------------------------------

//Creado por dr2 en 2020-07-28
//https://www.shadertoy.com/view/3lfBz8
mat3 StdVuMat (float el, float az)
{
  vec2 ori, ca, sa;
  ori = vec2 (el, az);
  ca = cos (ori);
  sa = sin (ori);
  return mat3 (ca.y, 0., - sa.y, 0., 1., 0., sa.y, 0., ca.y) *
         mat3 (1., 0., 0., 0., ca.x, - sa.x, 0., sa.x, ca.x);
}


//Creado por dr2 en 2020-07-28
//https://www.shadertoy.com/view/3lfBz8
vec3 getMouse(vec3 ro)
{    
     vec4 mPtr = iMouse;
  mPtr.xy = mPtr.xy / iResolution.xy - 0.5;
  float tCur = iTime;
    
  float az = 0.;
  float el = -0.15 * PI;

    az += 2. * PI * mPtr.x;
    el += PI * mPtr.y;
 
    
    
  mat3 vuMat = StdVuMat (el, az);
	return ro*vuMat;
}



//-------------------------------
vec3 getColorTex( vec3 p, vec3 nor,  int i)
{
    
	if (i==100 ) { return tex3D(texture0, p/32., nor); }
	if (i==101 ) { return tex3D(texture1, p/32., nor); }
	if (i==102 ) { return tex3D(texture2, p/32., nor); }
	if (i==103 ) { return tex3D(texture3, p/32., nor); }
   
    
}


vec3 Getluz(vec3 p, vec3 ro, vec3 nor , vec3 colobj ,vec3 plight_pos)
{   
     
    vec3 lightPos = plight_pos;
    float intensity=1.0;
	const float shininess = 100.0;
	vec3 l = normalize( p-lightPos);
    vec3 v = normalize( p-ro);
    vec3 h = normalize(v + l);
    float diff = dot(nor, l);
    float spec = max(0.0, pow(dot(nor, h), shininess)) * float(diff > 0.0);
	vec3 result = LightShading(nor,l,v, colobj)*intensity;
    return result;
}
    


//------------------------------------------------

vec3 GetColorYsurface(inout vec3 p, inout vec3 n, inout vec3 rd, int opmat)
{
   	vec3 colobj;
    
    
    if (opmat<100)
		{ colobj=getColor(int( opmat)); }
    
    
    
    if ( float( opmat)>=100.0  && float( opmat)<=199.0 ) 
 	{  vec3 coltex=getColorTex(p, n, int( opmat));
        colobj=coltex;
	}

    
    return colobj;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
   vec2 uv = (fragCoord.xy -.5*iResolution.xy)/iResolution.y;
	
    itime = iTime;
    float t;
    t=mod(iTime*2.0,360.0);
   
    
 
 light_pos1   = vec3(10.0, 12.0, 10.0 ); 
 light_color1 = vec3( 1.0 );

 light_pos2   = vec3( 0.0, 15.0, 0.0 );
 light_color2 = vec3( 1.0, 1.0, 1.0 );
 
    
    
    vec3 ro=vec3(4.0,1.0,-25.0+t);
    //ro= getMouse(ro);
        
    vec3 rd=normalize(vec3(uv,1.));
    
    
  
    light_pos1+=ro;
    light_pos2+=ro;
    
    
    vec3 col = vec3(0);
    
    TObj Obj;
    
    mObj.uv=uv;
    mObj.rd=rd;
    mObj.ro=ro;

	 
    
    float d = RayMarch(ro, rd);
    Obj=mObj;
    
  
    vec3 p = (ro + rd * d ); 
    
    mObj.p=p;
    mObj.dist =d;
    vec3 nor= GetNormal( p);
    mObj.normal=nor;
  
    vec3 colobj;
    colobj=GetColorYsurface( p, nor, rd,  int( Obj.idcolor));
    

  float dif1=1.0;
   vec3 col2,col3;
    
    vec3 result;
    result=  Getluz( p,ro, nor, colobj ,light_pos1);
    result+= Getluz( p,ro, nor, colobj ,light_pos2);
    result/=1.25;
    col3=result;
    
    
     
  
    col= col3*dif1;
    
  	
    //sugerencia por dean_the_coder,
    //col *= 1.0 - pow(d / 100.0, 1.5);
    col *= 1.0 - pow(d / 100.0, 3.5);
    
    
    col = pow(col, vec3(1.0/2.2));  
    
    fragColor = vec4(col,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb)+0.33;
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.




